function [average,stdev] = stat(x)
% STAT Returns the average and standard deviation of vector
% average = STAT(x)
% [average,stdev] = STAT(x)
%
% HMC 06/10/2014 (adjusted by D.T. de Jong 22-11-2014)
% Test for the number input arguments
if (nargin > 1)
    error('Too many input arguments')
elseif (nargin < 1)
    error('Missing argument')
end
% Test whether x is a vector
[n1,n2] = size(x);
if (n1 == 1 || n2 == 1) && (length(x) == 1)        %adjusted statement
    error('x is not a vector')
end
% Calculation of average and standard deviation
n = max(n1,n2);
average = avg(x,n);
stdev = sqrt(sum((x - average).^2)/n);

    function [average] = avg(x,n)
        % internal averaging function
        average = sum(x)/n;
    end

end

