% Exercise43
% Continuation of the precious exercise. We will plot normal distributions
% over the plots
%
% D.T. de Jong 14-12-2014

M=load('wine.dat');
%Extract only the relvant index of the first column. Do not include the
%first column
v1=M(find(M(:,1)==1),8); %matrix for Barolo 58x13
v2=M(find(M(:,1)==2),8); %matrix for Gignolino 71x13
v3=M(find(M(:,1)==3),8); %matrix for Barbera 48x13

%The calculations for each of the wines separately, used function: stat
[av1,stdev1]=stat(v1);
[av2,stdev2]=stat(v2);
[av3,stdev3]=stat(v3);

x = linspace(0,6,100);

% Normpdf for wine types separately
d1 = normpdf(x,av1,stdev1);
d2 = normpdf(x,av2,stdev2);
d3 = normpdf(x,av3,stdev3);

% RESCALE, for a given vector x we can assume that the sum of the vector
% ydist should be the same as that of the experimental vector:
y1=sum(h1)/sum(d1)*d1;
y2=sum(h2)/sum(d2)*d2;
y3=sum(h3)/sum(d3)*d3;


edges = linspace(0,6,60); % define the edges: 60 steps 

% We would like to use hist and bar
figure(1)
h1= hist(v1,edges);
h2= hist(v2,edges);
h3= hist(v3,edges);
bar(edges,[h1' h2' h3'],'histc')
hold on
plot(x,[y1' y2' y3']);

hold off
axis([0 6 0 15]) 
legend('Barolo Flavonoids','Gignolino Flavonoids','Barbera Flavonoids')
xlabel('Concentration')
ylabel('Number of samples')


% Note the difference when y1,y2, and y3 are replaced with d1,d2, d3,
% respectively. That is why rescaling is needed. 




 
