% Exercise42
% Use the concentration of the flavonoids (column7) of the winedata to
% discriminate between the different classes. We construct a figure that
% shows three histograms for the three different classes using the same
% bins. We would like 60 bins between 0 and 6.
%
% D.T. de Jong 14-12-2014

M=load('wine.dat');
%Extract only the relevant index of the first column. Do not include the
%first column
v1=M(find(M(:,1)==1),8); %matrix for Barolo 58x13
v2=M(find(M(:,1)==2),8); %matrix for Gignolino 71x13
v3=M(find(M(:,1)==3),8); %matrix for Barbera 48x13

edges = linspace(0,6,60); % define the edges: 60 steps 

% We would like to use hist and subplots
figure(1)
h1= hist(v1,edges);
h2= hist(v2,edges);
h3= hist(v3,edges);

bar(edges,[h1' h2' h3'],'histc')
axis([0 6 0 15]) 
legend('Barolo Flavonoids','Gignolino Flavonoids','Barbera Flavonoids')
xlabel('Concentration')
ylabel('Number of samples')




 
