% Exercise 38
% Calculate the average and stadard deviation of the three sets of
% measurements. statm.m and stat.m are used (which are from chapter 4).
% statm.m is the same as stat.m, but is adjusted to accept matrices as
% input.
%
% D.T. de Jong 14-12-2014
% Edit by WF, HMC 20-01-2015

M = load('wine.dat');
%Extract only the relevant index of the first column. Do not include the
%first column
barolo = M(find(M(:,1)==1),2:end); %matrix for Barolo 58x13
gignolino = M(find(M(:,1)==2),2:end); %matrix for Gignolino 71x13
barbera = M(find(M(:,1)==3),2:end); %matrix for Barbera 48x13

%The calculations for each of the wines separately, used function: statm
[Tavg,Tsd]=statm(M(:,2:end));
[av1,stdev1]=statm(barolo);
[av2,stdev2]=statm(gignolino);
[av3,stdev3]=statm(barbera);

%plot bars of the autoscaled data |(mean substracted and divided by the sdv)
bar([(av1'-Tavg')./Tsd' (av2'-Tavg')./Tsd' (av3'-Tavg')./Tsd'])
figure
bar([stdev1' stdev2' stdev3'])

disp('Based on this, variable 6 and 7 are selected')




