function [av,stdev] = statm(x)
% Function which calculates the mean and standard deviation of matrices as
% input. It is calculated for each column separately. It returns the
% average and standard deviation [av, stdev]=statm(x)
%
% D.T. de Jong 14-12-2014
n = size(x,1);
av = avg(x,n);
H=ones(n,1)*av; %fix matrix dimensions with a help matrix H
stdev = sqrt(sum((x-H).^2)/n);
end

function [av] = avg(x,n) % this is a subfunction
av = sum(x)/n;
end