function f = euler(diffeqs, f0, t)
% function EULER integrates function DIFFEQS at times T, using 
% initial values F0.

if (nargin < 3)
    error('Missing input argument(s)')
end

[t1, t2] = size(t);
if not((t1 == 1) || (t2 == 1))
    error('t is not a vector')
end

f = zeros(length(f0),max(t1,t2));
f(:,1) = f0;

for i = 2:length(t)
    dt = t(i)-t(i-1);
    dfdt = diffeqs(f(:,i-1));  
   f(:,i) = f(:,i-1) + dfdt*dt;
end

end
