function [ Hypothesis ] = anovatable( Data,Type )
Alpha=0.05;


Parts=unique(Type);
TotMean=mean(Data);
n=length(Parts);
%Initialize SS between
SSbet=0;
for iii=1:n
    
    TempData=Data(find(Type==Parts(iii)));
    m(iii)=length(TempData);
    Means(iii)=mean(TempData);
    SSint(iii)=sum((TempData-Means(iii)).^2);
    SSbet=SSbet+m(iii)*(Means(iii)-TotMean)^2;
	Freedom(iii)=m(iii)-1;
    MSquares(iii)=SSint(iii)/Freedom(iii);

end
FreeBet=n-1;
MSbet=SSbet/FreeBet;
FreeWithin=sum(Freedom);
SSwithin=sum(SSint);
MSwithin=SSwithin/FreeWithin;

F=MSbet/MSwithin;

Prop=fcdf(1/F,FreeBet,FreeWithin);

if Prop>Alpha
    Hypothesis=true;
else
    Hypothesis=false;
end

%Print Table-----------------------------------------
fprintf(1,'Source\tSS\tFreedom\t\tMean Squares\t\tF\n');
fprintf(1,'=============================================================\n');
for iii=1:n
    fprintf(1,'%d\t%.2f\t  %d\t\t    %.2f\n',Parts(iii),SSint(iii),Freedom(iii), MSquares(iii));
end
fprintf(1,'-------------------------------------------------------------\n');
fprintf(1,'Within\t%.2f\t  %d\t\t    %.2f\n',SSwithin,FreeWithin,MSwithin);
fprintf(1,'Between\t%.2f\t  %d\t\t    %.2f\n',SSbet,FreeBet,MSbet);
fprintf(1,'-------------------------------------------------------------\n');
fprintf(1,'Total\t%.2f\t  %d\t\t\t\t      %.2f\n',SSbet+SSwithin,FreeWithin+FreeBet,F);


    

end

