% Exercise 39
% a
r0 = 0.01;
r = linspace(r0, 10, 1000);

drdt = @(r)(r.^2 - r.^3);

plot(r,drdt(r))

% for r0 = 0 dr/dt =0 and we cannot progress using Euler integration (r_n+1 = r_n + Delta t * dr/dt -> r_n+1 = r_)

% b
t = [0:1000];
r = euler(drdt,r0,t);

plot(t,r)

% since for smaller r0 dr/dt is also smaller it takes longer to progress to the steady state value

% c
% dr/dt = r^2 - r^3 = (1- delta)^2 - (1 - delta)(1 - delta)^2 = ( 1 - 1 + delta)(1 - delta)^2 = delta (1 - delta)^2
% r_i+1 = 1 - delta + (Delta t) * delta * (1 - delta)^2 

% d
% delta t should be much between 0 and 1

% e 
% for r0 = 0.01 -> tss = 2/0.01 = 200 -> minimum 200 timesteps
% for r0 = 0.0001 -> tss = 2/0.0001 = 20000 -> minimum 200 timesteps

%f
odeopt = odeset('RelTol',1e-4);
[t,r] = ode45(drdt,[0 2/r0],r0,odeopt);

%g
r0 = 0.0001;
odeopt = odeset('RelTol',1e-4);
[t,r] = ode45(drdt,[0 2/r0],r0,odeopt);
