function opt = simplex(myfun, xmin, xmax )

% intialize first simplex
deltax = (xmax-xmin)/10;
s0 = rand(1,2).*(xmax-xmin)+xmin;
s0 = repmat(s0,3,1);
s0(2,1) = s0(2,1) + deltax(1);
s0(3,2) = s0(3,2) + deltax(2)*0.8;
s0(3,1) = s0(3,1) + deltax(1)*0.2;

diffz = 1000;
diffs = 1000;
for j = 1:3
  z(j) = myfun(s0(j,:));
end
[z, i] = sort(z);
s0 = s0(i,:);
s = s0;

while (diffz > 1e-6 && diffs > 1e-6)
  oldz = sum(z);

  cen = s(2,:) + (s(1,:)-s(2,:))/2;
  r = cen + (cen-s(3,:));
  e = r + (cen-s(3,:));
  
  w = s(3,:);
  
  if (within(r,xmin,xmax) && myfun(r) < z(3) && myfun(r) > z(1))
    s(3,:) = r;
  elseif (within(e,xmin,xmax) && myfun(e) < z(1) )
    s(3,:) = e;
  else 
    s(3,:) = cen - (cen-s(3,:))/2;
  end
  
  for j = 1:3
    z(j) = myfun(s(j,:));
  end
  [z,i] = sort(z);
  s = s(i,:);
  
  diffz = abs(sum(z) - oldz);
  diffs = sum(abs(s(3,:) - s0(3,:)));
  s0 = s;
end

opt = s(1,:);
