function f = banana(r)
% BANANA Returns the Rosenbrock banana function 
% f(x,y)=100(y-x^2)^2+(1-x)^2
% f = banana(r)
% with r containing the x and y values
% D.T. de Jong 22-11-2014

% Test for the number of input arguments
if (nargin > 1)
    error('Too many input arguments')
elseif (nargin <1)
    error ('Missing input argument')
end

% Check for the length of r
if length(r) ~= 2
    error('x is not a 2x1 or 1x2 vector')
end

f = 100*(r(2)-r(1)^2)^2+(1-r(1))^2;

end