function f = a_banana(r,a)
% A_BANANA Returns the modified Rosenbrock banana function 
% f(x,y)=100(y-x^2)^2+(a-x)^2
% f = banana(r,a)
% with r containing the x and y values
% D.T. de Jong 22-11-2014

% Test for the number of input arguments
if (nargin > 2)
    error('Too many input arguments')
elseif (nargin <2)
    error ('Missing input argument')
end

% Check for the length of r
if length(r) ~= 2
    error('r is not a 2x1 or 1x2 vector')
end

% Check for the length of a
if length(a) ~= 1
    error('a is not a scalar')
end

f = 100*(r(2)-r(1)^2)^2+(a-r(1))^2;

end