function [xnew,iter] = newton(myfun, x, tol)
% NEWTON finds zero point of function using the Newton-Raphson method
% [x0,iter] = newton(myfun, x, tol)
%
% HMC

ynew = 10;

iter = 0;

xnew = x;

deltax = x/100;

while (ynew > tol)
  iter = iter + 1;
  
  x = xnew;
  y = myfun(x);
  a = (myfun(x+deltax)-y)/deltax;
  xnew = x - y/a; 
  ynew = myfun(xnew);
end

% Newton-Raphson requires much less iteration
