function [x0,iter] = bisection(myfun, x1, x2, tol)
% BISECTION returns the root of function myfun
% [x0, iter] = bisection(myfun, x1, x2, tol)
% within the interval x1 to x2 with a precision of tol
%
% D.T. de Jong 22-11-2014

%check whether x1 < x2 holds
if x1 >= x2
    error('x1 < x2 does not hold')
end
%check whether the intersection lies in between the functionvalues
if (myfun(x1)>0 && myfun(x2)>0) || (myfun(x1)<0 && myfun(x2)<0)
    error('the function values do not have an opposite sign')
end

c = (x1+x2)/2; % starting midpoint

iter = 0;

while abs(myfun(c))>tol %Use a while loop, untill the desired tol is fulfilled
  iter = iter + 1;
  % Shorten the search-interval
  if myfun(c)*myfun(x1) < 0       % Examine the sign
    x2 = c;
  elseif myfun(c)*myfun(x2) < 0   % Examine the sign
    x1 = c;
  else
    disp('The function has no root on this interval')
    break
  end

  c = (x1+x2)/2;  % Define the new midpoint
end
x0 = c;         % when the accuracy is met, design the midpoint to be the root.
