function [r, theta, phi] = cartpol(x)
% CARTPOL returns the spherical polar coordinates from a 3-dim vector
% that contains Cartesian coordinates
%
% [r, theta, phi] = cartpol(x)
%
%  D.T. de Jong 22-11-2014

% Test for the number of input arguments
if (nargin > 1)
    error('Too many input arguments')
elseif (nargin <1)
    error ('Missing input argument')
end

% Check for the length of x
if length(x) ~= 3
    error('x is not a 3x1 or 1x3 vector')
end

% The conversion formulas
r = sqrt(x(1)^2+x(2)^2+x(3)^2);
theta = acos(x(3)/(r));
phi = atan((x(2)/x(1)));
% Note that the answers are given in radians.

end
