% Exercise 29

T     = (0:100)';            % A 101 temperatures from 0 to 100 celcius.
n     = size(T, 1);          % n = 101.
T0    = -273;                % Approximately the absolute zero in celcius.
c0    = 4.2;                 % Just made these up.
c1    = 0.1;
c2    = 1e-2;
noise = 4e11*(rand(n,1)-0.5)./(T-T0).^4;  % The noise.
p     = c0 + c1*(T-T0) + c2*(T-T0).^2 + noise; % The simulated pressures.

A = make_polyn(T,3);

x = A\p;


w = (T-T0).^4;          % Define the temperature dependent weights.
W = diag(w);            % diag(w) turns a vector into a diagonal matrix.
x2 = (W*A)\(W*p);       % Solve the weighted linear least squares problem.


plot(T,p,T,A*x,T,A*x2)

realx= [776.79 5.56 1e-2]';

disp((realx-x)./realx)
disp((realx-x2)./realx)
