% Exercise 35
% Loading wine data and saving it in separate files. No precision may be
% lost. A for loop is used. Data is right-justified. 
%
% D.T. de Jong 07-12-2014

M=load('wine.dat');            % Load the wine data
[m1, m2] = size(M);             % m1 = 177 rows, m2 = 13 columns

for i = 1:m2
    
    % Create filenames
    filename = sprintf('%s%02d%s','wine',i,'.dat');   % A zero should be displayed
    
    v = M(:,i);                                   % Select the i-th column
    
    FID = fopen(filename, 'w');
    
    for j = 1:m1
      fprintf(FID, '%g\n', v(j));                   % Translate the column vector
    end                                           % into the .dat file.
    fclose(FID);
    % Note '%g'% is used to get all the significant digits; no precision is
    % lost. 
    
end
