 % Exercise 33
% Plots of the Mexican Hat on the interval [-3,3] x [-3,3] without the use
% of for loops. Mesh, surf and contour are used. Vectors are used for the
% parameters.
%
%D. T. de Jong 07-12-2014

x = linspace(-3,3,100);
y = linspace(-3,3,100);
[X,Y] = meshgrid(x, y);  % transforms vectors x and y into two-dimensional
                         % arrays X and Y that can be used with dot
                         % operations to compute Z.

tic()
Z = (1-X.^2-Y.^2).*exp(-0.5.*(X.^2+Y.^2));    % use dot operations
% Z still must be a matrix!
toc()

%Elapsed time is 0.00150895 seconds

ZZ = ones(100,100);
tic()
for i = 1:100
  for j = 1:100
    ZZ(i,j) = (1-x(i)^2-y(j)^2)*exp(-0.5*(x(i)^2+y(j)^2));
  end
end
toc()

%Elapsed time is 0.259757 seconds

mesh(x,y,Z) % now with x and y instead of X and Y
xlabel('x')
ylabel('y')
zlabel('z')
title('Mesh of Mexican Hat')

pause                   

mesh(x,y,ZZ) % now with x and y instead of X and Y
xlabel('x')
ylabel('y')
zlabel('z')
title('Surf of Mexican Hat')

pause                      

mesh(x,y,Z-ZZ) % now with x and y instead of X and Y
xlabel('x')
ylabel('y')
zlabel('z')
title('Contour of Mexican Hat')
colorbar       % Added a colorbar 

% Conclusion: the results are indeed the same







